const Extractor = require('./Extractor.js');
const Result = require('../Results/Result.js');
const {clipboard} = require('electron')

const MathExtractor = function() {
	Extractor.call(this, 'MathExtractor');
};
MathExtractor.prototype = Object.create(Extractor.prototype);
MathExtractor.prototype.extract = function(query) {
	this.results = [];
	try {
		if(/^[0-9a-fx().*/+-]+$/.test(query)) {
			const result = eval(query);
			if(result !== undefined && result !== null && result !== false && !Number.isNaN(result)) {
				const r = new Result(result.toLocaleString('en-US'));
				r.subtitle = `= ${query}`
				r.primaryAction = function() {
					clipboard.writeText(result.toString())
					Result.prototype.primaryAction.call(this)
				}
				this.results.push(r);
			}
		}
	} catch(e) {}
};

module.exports = MathExtractor;