const electron = require('electron');
const {app, BrowserWindow, globalShortcut} = electron;
const path = require('path');
const url = require('url');
const config = require('./config.js');

let window = null;

app.on('ready', _ => {
	const screenWidth = electron.screen.getPrimaryDisplay().workAreaSize.width;
	window = new BrowserWindow({
		title: 'Artemis',
		x: (screenWidth - config.width)/2,
		y: 0,
		titleBarStyle: 'hidden',
		width: config.width,
    	show: config.visibleOnStart,
		height: 57,
		icon: './images/icon.png',
		frame: false,
		resizable: false,
		'always-on-top': true
	});
	window.setMenuBarVisibility(false);
	globalShortcut.register(config.shortcut, _ => {
		if(window.isVisible())
			window.hide();
		else
			window.show();
	});

	if(config.debug)
		window.webContents.openDevTools({mode: "detach"})
	
	window.on('close', _ => window = null);
	window.loadURL(url.format({
		pathname: path.join(__dirname, 'index.html'),
		protocol: 'file:',
		slashes: true
	}));
});
app.on('window-all-closed', _ => app.quit());